<?php
// /panel/install_raw.php - instalador con salida en texto plano
header('Content-Type: text/plain; charset=utf-8');
error_reporting(E_ALL); ini_set('display_errors','1');
require_once __DIR__.'/config.php';

try{
  $pdo=new PDO('mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4', DB_USER, DB_PASS,[
    PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC,
  ]);
  echo "MySQL CONNECT OK\n";
}catch(Throwable $e){ echo "CONNECT FAIL: ".$e->getMessage()."\n"; exit; }

$sqls = [
"CREATE TABLE IF NOT EXISTS nmc_centers (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(12) NOT NULL,
  name VARCHAR(120) NOT NULL,
  city VARCHAR(80), address VARCHAR(180), postal_code VARCHAR(12),
  phone VARCHAR(30), email VARCHAR(120),
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY uq_centers_code (code)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
"CREATE TABLE IF NOT EXISTS nmc_units (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  center_id INT UNSIGNED NOT NULL,
  unit_number VARCHAR(20) NOT NULL,
  size_sqm DECIMAL(6,2) NOT NULL,
  price_month_cents INT UNSIGNED NOT NULL DEFAULT 0,
  price_year9_cents INT UNSIGNED NOT NULL DEFAULT 0,
  manual_price_cents INT UNSIGNED NOT NULL DEFAULT 0,
  status ENUM('available','reserved','occupied','maintenance','blocked') NOT NULL DEFAULT 'available',
  reserved_until DATETIME NULL,
  notes TEXT NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY uq_units_center_number (center_id, unit_number),
  INDEX idx_units_center (center_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
"CREATE TABLE IF NOT EXISTS nmc_customers (
  id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  full_name VARCHAR(120) NOT NULL,
  email VARCHAR(160), phone VARCHAR(40), dni VARCHAR(32),
  address VARCHAR(200), city VARCHAR(80), postal_code VARCHAR(12),
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
"CREATE TABLE IF NOT EXISTS nmc_reservations (
  id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  unit_id INT UNSIGNED NOT NULL,
  customer_id BIGINT UNSIGNED NULL,
  reservation_code VARCHAR(32) NOT NULL,
  period ENUM('monthly','annual','9months') NOT NULL DEFAULT 'monthly',
  start_date DATE NOT NULL, end_date DATE NULL,
  price_cents INT UNSIGNED NOT NULL DEFAULT 0, currency CHAR(3) NOT NULL DEFAULT 'EUR',
  status ENUM('pending','paid','cancelled','expired','refunded') NOT NULL DEFAULT 'pending',
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY uq_res_code (reservation_code)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"
];
foreach($sqls as $i=>$s){
  try{ $pdo->exec($s); echo "OK [$i]\n"; }
  catch(Throwable $e){ echo "FAIL [$i]: ".$e->getMessage()."\n"; }
}
try{ $pdo->exec("INSERT IGNORE INTO nmc_centers (id,code,name,is_active) VALUES (1,'DEF','Centro por defecto',1)"); echo "Seed center OK\n"; }
catch(Throwable $e){ echo "Seed center FAIL: ".$e->getMessage()."\n"; }
echo "DONE\n";
